/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.availability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.api.handler.data.IQuest;
import noppes.npcs.client.gui.select.GuiQuestSelection;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiSelectionListener;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumAvailabilityQuest;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.Quest;

public class SubGuiNpcAvailabilityQuest
extends SubGuiInterface
implements ICustomScrollListener,
GuiSelectionListener {
    protected static final String[] types = new String[]{"availability.always", "availability.after", "availability.before", "availability.active", "availability.notactive", "availability.completed", "availability.canstart"};
    protected final Availability availability;
    protected final Map<String, EnumAvailabilityQuest> dataEnum = new HashMap<String, EnumAvailabilityQuest>();
    protected final Map<String, Integer> dataIDs = new HashMap<String, Integer>();
    protected GuiCustomScroll scroll;
    protected String select = "";

    public SubGuiNpcAvailabilityQuest(Availability availabilityIn) {
        this.setBackground("menubg.png");
        this.xSize = 316;
        this.ySize = 217;
        this.closeOnEsc = true;
        this.availability = availabilityIn;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                if (this.select.isEmpty()) {
                    return;
                }
                EnumAvailabilityQuest ead = EnumAvailabilityQuest.values()[button.getValue()];
                int id = this.dataIDs.get(this.select);
                this.availability.quests.put(id, ead);
                Quest quest = QuestController.instance.quests.get(this.dataIDs.get(this.select));
                this.select = "ID:" + id + " - ";
                this.select = quest == null ? this.select + "\u00a74" + new TextComponentTranslation("quest.found", new Object[0]).func_150254_d() : this.select + "\u00a77" + quest.getCategory().getName() + "/" + '\u00a7' + "r" + quest.getName() + '\u00a7' + "7 (" + '\u00a7' + "9" + new TextComponentTranslation(("availability." + (Object)((Object)ead)).toLowerCase(), new Object[0]).func_150254_d() + '\u00a7' + "7)";
                this.func_73866_w_();
                break;
            }
            case 1: {
                this.setSubGui(new GuiQuestSelection(this.select.isEmpty() ? 0 : this.dataIDs.get(this.select)));
                break;
            }
            case 2: {
                this.availability.quests.remove(this.dataIDs.get(this.select));
                this.select = "";
                this.func_73866_w_();
                break;
            }
            case 3: {
                this.save();
                this.func_73866_w_();
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    @Override
    public void close() {
        super.close();
        ArrayList<Integer> delete = new ArrayList<Integer>();
        for (int id : this.availability.quests.keySet()) {
            if (this.availability.quests.get(id) != EnumAvailabilityQuest.Always) continue;
            delete.add(id);
        }
        for (int id : delete) {
            this.availability.quests.remove(id);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addLabel(new GuiNpcLabel(1, "availability.available", this.guiLeft, this.guiTop + 4));
        this.getLabel(1).setCenter(this.xSize);
        GuiNpcButton button = new GuiNpcButton(66, this.guiLeft + 6, this.guiTop + 192, 70, 20, "gui.done");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 6);
            this.scroll.setSize(this.xSize - 12, this.ySize - 66);
        }
        this.dataIDs.clear();
        this.dataEnum.clear();
        for (int id : this.availability.quests.keySet()) {
            String key = "ID:" + id + " - ";
            IQuest q = QuestController.instance.get(id);
            key = q == null ? key + "\u00a74" + new TextComponentTranslation("quest.notfound", new Object[0]).func_150254_d() : key + "\u00a77" + q.getCategory().getName() + "/" + '\u00a7' + "r" + q.getName() + '\u00a7' + "7 (" + '\u00a7' + "9" + new TextComponentTranslation(("availability." + (Object)((Object)this.availability.quests.get(id))).toLowerCase(), new Object[0]).func_150254_d() + '\u00a7' + "7)";
            this.dataIDs.put(key, id);
            this.dataEnum.put(key, this.availability.quests.get(id));
        }
        if (!this.select.isEmpty() && !this.dataIDs.containsKey(this.select)) {
            this.select = "";
        }
        this.scroll.setList(new ArrayList<String>(this.dataIDs.keySet()));
        this.scroll.guiLeft = this.guiLeft + 6;
        this.scroll.guiTop = this.guiTop + 14;
        if (!this.select.isEmpty()) {
            this.scroll.setSelected(this.select);
        }
        this.addScroll(this.scroll);
        int p = 0;
        if (!this.select.isEmpty()) {
            p = this.dataEnum.get(this.select).ordinal();
        }
        button = new GuiNpcButton(0, this.guiLeft + 6, this.guiTop + this.ySize - 46, 100, 20, types, p);
        button.setHoverText("availability.hover.enum.type", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(1, this.guiLeft + 108, this.guiTop + this.ySize - 46, 180, 20, "availability.select");
        button.setHoverText("availability.hover.quest", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, this.guiLeft + 290, this.guiTop + this.ySize - 46, 20, 20, "X");
        button.setHoverText("availability.hover.remove", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(3, this.guiLeft + this.xSize - 76, this.guiTop + 192, 70, 20, "availability.more");
        button.setEnabled(!this.select.isEmpty());
        button.setHoverText("availability.hover.more", new Object[0]);
        this.addButton(button);
        this.updateGuiButtons();
    }

    @Override
    public void save() {
        if (this.select.isEmpty()) {
            return;
        }
        EnumAvailabilityQuest ead = EnumAvailabilityQuest.values()[this.getButton(0).getValue()];
        int id = this.dataIDs.get(this.select);
        if (ead != EnumAvailabilityQuest.Always) {
            this.availability.quests.put(id, ead);
            this.dataEnum.put(this.select, ead);
        } else {
            this.availability.quests.remove(id);
        }
        this.select = "";
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        this.select = scroll.getSelected();
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
        this.setSubGui(new GuiQuestSelection(this.dataIDs.get(select)));
    }

    @Override
    public void selected(int id, String name) {
        if (id <= 0) {
            return;
        }
        if (!this.select.isEmpty()) {
            this.availability.quests.remove(this.dataIDs.get(this.select));
        }
        Quest quest = QuestController.instance.quests.get(id);
        this.select = "ID:" + id + " - " + '\u00a7' + "7" + quest.category.getName() + "/" + '\u00a7' + "r" + quest.getName() + '\u00a7' + "7 (" + '\u00a7' + "9" + new TextComponentTranslation("availability.after", new Object[0]).func_150254_d() + '\u00a7' + "7)";
        this.availability.quests.put(id, EnumAvailabilityQuest.After);
        this.func_73866_w_();
    }

    private void updateGuiButtons() {
        int p = 0;
        this.getButton(1).setDisplayText("availability.selectquest");
        Quest quest = null;
        if (!this.select.isEmpty()) {
            quest = QuestController.instance.quests.get(this.dataIDs.get(this.select));
            p = this.dataEnum.get(this.select).ordinal();
        }
        this.getButton(0).setDisplay(p);
        this.getButton(0).setEnabled(!this.select.isEmpty());
        this.getButton(1).setEnabled(p != 0 || this.select.isEmpty());
        this.getButton(1).setDisplayText(quest == null ? "availability.select" : quest.getName());
        this.getButton(2).setEnabled(p != 0);
    }
}

